/////////////////////////////////////////////////////////////
// CINEMA SDK : FILTER																	   //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_FILTERPLUGIN_H
#define __C4D_FILTERPLUGIN_H

#include "ge_math.h"
#include "c4d_filterdata.h"
#include "c4d_nodeplugin.h"

#define PLUGINFLAG_BITMAPSAVER_ALLOWOPTIONS		(1<<27)
#define PLUGINFLAG_BITMAPSAVER_FORCESUFFIX		(1<<28)

struct BITMAPLOADERPLUGIN : public STATICPLUGIN
{
	Bool (BitmapLoaderData::*Identify			)(const Filename &name, UCHAR *probe, LONG size);
	LONG (BitmapLoaderData::*Load					)(const Filename &name, BaseBitmap *bm, LONG frame);
	LONG (BitmapLoaderData::*GetSaver			)(void);

	void*	reserved[(32-3)*C4DPL_MEMBERMULTIPLIER];
};

struct BITMAPSAVERPLUGIN : public STATICPLUGIN
{
	String		*suffix;

	LONG (BitmapSaverData::*Save					)(const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits);
	Bool (BitmapSaverData::*Edit					)(BaseContainer *data);
	LONG (BitmapSaverData::*GetMaxAlphas	)(BaseContainer *data);

	void*	reserved[(32-3)*C4DPL_MEMBERMULTIPLIER-1];
};

struct SCENELOADERPLUGIN : public NODEPLUGIN
{
	Bool (SceneLoaderData::*Identify			)(PluginSceneLoader *node, const Filename &name, UCHAR *probe, LONG size);
	LONG (SceneLoaderData::*Load					)(PluginSceneLoader *node, const Filename &name, BaseDocument *doc, LONG filterflags, String *error, Bool *framescene);

	void*	reserved[(32-2)*C4DPL_MEMBERMULTIPLIER-0];
};

struct SCENESAVERPLUGIN : public NODEPLUGIN
{
	String		*suffix;

	LONG (SceneSaverData::*Save						)(PluginSceneSaver *node, const Filename &name, BaseDocument *doc, LONG filterflags);

	void*	reserved[(32-1)*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
